/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Hashtable;
import org.microemu.device.DeviceFactory;

public final class Font {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int FONT_STATIC_TEXT = 0;
    public static final int FONT_INPUT_TEXT = 1;
    private static final Font DEFAULT_FONT = new Font(0, 0, 0);
    private static Font[] fontsBySpecifier = new Font[]{DEFAULT_FONT, DEFAULT_FONT};
    private static Hashtable fonts = new Hashtable();
    private int face;
    private int style;
    private int size;
    private int baselinePosition = -1;
    private int height = -1;

    private Font(int n2, int n3, int n4) {
        if (n2 != 0 && n2 != 32 && n2 != 64) {
            throw new IllegalArgumentException();
        }
        if (!(this.isPlain() || this.isBold() || this.isItalic() || this.isUnderlined())) {
            throw new IllegalArgumentException();
        }
        if (n4 != 8 && n4 != 0 && n4 != 16) {
            throw new IllegalArgumentException();
        }
        this.face = n2;
        this.style = n3;
        this.size = n4;
    }

    public static Font getDefaultFont() {
        return DEFAULT_FONT;
    }

    public static Font getFont(int n2) {
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("Bad specifier");
        }
        return fontsBySpecifier[n2];
    }

    public static Font getFont(int n2, int n3, int n4) {
        Integer n5 = new Integer(n3 + n4 + n2);
        Font font = (Font)fonts.get(n5);
        if (font == null) {
            font = new Font(n2, n3, n4);
            fonts.put(n5, font);
        }
        return font;
    }

    public final int getStyle() {
        return this.style;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getFace() {
        return this.face;
    }

    public final boolean isPlain() {
        return this.style == 0;
    }

    public final boolean isBold() {
        return (this.style & 1) != 0;
    }

    public final boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public final boolean isUnderlined() {
        return (this.style & 4) != 0;
    }

    public final int getHeight() {
        if (this.height == -1) {
            this.height = DeviceFactory.getDevice().getFontManager().getHeight(this);
        }
        return this.height;
    }

    public final int getBaselinePosition() {
        if (this.baselinePosition == -1) {
            this.baselinePosition = DeviceFactory.getDevice().getFontManager().getBaselinePosition(this);
        }
        return this.baselinePosition;
    }

    public final int charWidth(char c2) {
        return DeviceFactory.getDevice().getFontManager().charWidth(this, c2);
    }

    public final int charsWidth(char[] cArray, int n2, int n3) {
        return DeviceFactory.getDevice().getFontManager().charsWidth(this, cArray, n2, n3);
    }

    public final int stringWidth(String string) {
        return DeviceFactory.getDevice().getFontManager().stringWidth(this, string);
    }

    public final int substringWidth(String string, int n2, int n3) {
        int n4 = n2;
        return this.stringWidth(string.substring(n4, n4 + n3));
    }

    public final int hashCode() {
        return this.style + this.size + this.face;
    }
}

