/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;

public class TiledLayer
extends Layer {
    private final int rows;
    private final int cols;
    Image img;
    private int tileHeight;
    private int tileWidth;
    private int numStaticTiles;
    private int[][] tiles;
    int[] animatedTiles;
    int numAnimatedTiles;

    public TiledLayer(int n2, int n3, Image image, int n4, int n5) {
        super(0, 0, n2 * n4, n3 * n5, true);
        if (image == null) {
            throw new NullPointerException();
        }
        if (n2 <= 0 || n3 <= 0 || n5 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException();
        }
        if (image.getWidth() % n4 != 0 || image.getHeight() % n5 != 0) {
            throw new IllegalArgumentException();
        }
        this.img = image;
        this.cols = n2;
        this.rows = n3;
        this.tileWidth = n4;
        this.tileHeight = n5;
        this.numStaticTiles = image.getWidth() / n4 * (image.getHeight() / n5);
        this.tiles = new int[n3][n2];
        this.animatedTiles = new int[5];
        this.numAnimatedTiles = 0;
    }

    public int createAnimatedTile(int n2) {
        TiledLayer tiledLayer = this;
        synchronized (tiledLayer) {
            if (n2 < 0 || n2 > this.numStaticTiles) {
                throw new IndexOutOfBoundsException();
            }
            if (this.numAnimatedTiles == this.animatedTiles.length) {
                int[] nArray = new int[this.numAnimatedTiles + 6];
                System.arraycopy(this.animatedTiles, 0, nArray, 0, this.numAnimatedTiles);
                this.animatedTiles = nArray;
            }
            this.animatedTiles[this.numAnimatedTiles] = n2;
            ++this.numAnimatedTiles;
            return -this.numAnimatedTiles;
        }
    }

    public int getAnimatedTile(int n2) {
        TiledLayer tiledLayer = this;
        synchronized (tiledLayer) {
            n2 = -n2 - 1;
            if (n2 < 0 || n2 >= this.numAnimatedTiles) {
                throw new IndexOutOfBoundsException();
            }
            return this.animatedTiles[n2];
        }
    }

    public void setAnimatedTile(int n2, int n3) {
        TiledLayer tiledLayer = this;
        synchronized (tiledLayer) {
            n2 = -n2 - 1;
            if (n2 < 0 || n2 >= this.numAnimatedTiles) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 < 0 || n3 > this.numStaticTiles) {
                throw new IndexOutOfBoundsException();
            }
            this.animatedTiles[n2] = n3;
            return;
        }
    }

    public int getCell(int n2, int n3) {
        return this.tiles[n3][n2];
    }

    public void setCell(int n2, int n3, int n4) {
        TiledLayer tiledLayer = this;
        synchronized (tiledLayer) {
            if (-n4 - 1 >= this.numAnimatedTiles || n4 > this.numStaticTiles) {
                throw new IndexOutOfBoundsException();
            }
            this.tiles[n3][n2] = n4;
            return;
        }
    }

    public void setStaticTileSet(Image object, int n2, int n3) {
        object = this;
        synchronized (object) {
            if (this.img == null) {
                throw new NullPointerException();
            }
            if (n3 <= 0 || n2 <= 0) {
                throw new IllegalArgumentException();
            }
            if (this.img.getWidth() % n2 != 0 || this.img.getHeight() % n3 != 0) {
                throw new IllegalArgumentException();
            }
            int n4 = this.img.getWidth() / this.getCellWidth() * (this.img.getHeight() / this.getCellHeight());
            int n5 = this.cols * n2;
            int n6 = this.rows * n3;
            this.setSize(n5, n6);
            this.img = this.img;
            this.tileWidth = n2;
            this.tileHeight = n3;
            if (n4 >= this.numStaticTiles) {
                this.numStaticTiles = n4;
                return;
            }
            this.numStaticTiles = n4;
            this.animatedTiles = new int[5];
            this.numAnimatedTiles = 0;
            this.fillCells(0, 0, this.getColumns(), this.getRows(), 0);
            return;
        }
    }

    public void fillCells(int n2, int n3, int n4, int n5, int n6) {
        TiledLayer tiledLayer = this;
        synchronized (tiledLayer) {
            if (n4 < 0 || n5 < 0) {
                throw new IllegalArgumentException();
            }
            if (n3 < 0 || n2 < 0 || n2 + n4 > this.cols || n3 + n5 > this.rows) {
                throw new IndexOutOfBoundsException();
            }
            if (-n6 - 1 >= this.numAnimatedTiles || n6 > this.numStaticTiles) {
                throw new IndexOutOfBoundsException();
            }
            n5 = n3 + n5;
            n4 = n2 + n4;
            while (n3 < n5) {
                for (int i2 = n2; i2 < n4; ++i2) {
                    this.tiles[n3][i2] = n6;
                }
                ++n3;
            }
            return;
        }
    }

    public final int getColumns() {
        return this.cols;
    }

    public final int getRows() {
        return this.rows;
    }

    public final int getCellWidth() {
        return this.tileWidth;
    }

    public final int getCellHeight() {
        return this.tileHeight;
    }

    public final void paint(Graphics graphics) {
        TiledLayer tiledLayer = this;
        synchronized (tiledLayer) {
            if (!this.isVisible()) {
                return;
            }
            int n2 = this.getX();
            int n3 = this.getY();
            int n4 = this.getColumns();
            int n5 = this.getRows();
            int n6 = this.getCellWidth();
            int n7 = this.getCellHeight();
            graphics.getClipX();
            graphics.getClipY();
            graphics.getClipWidth();
            graphics.getClipHeight();
            int n8 = n2;
            int n9 = this.img.getWidth() / n6;
            this.img.getHeight();
            int n10 = 0;
            while (n10 < n5) {
                n2 = n8;
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = this.getCell(n11, n10);
                    if (n12 < 0) {
                        n12 = this.getAnimatedTile(n12);
                    }
                    if (n12 != 0) {
                        int n13 = n6 * (--n12 % n9);
                        n12 = n12 / n9 * n7;
                        graphics.drawRegion(this.img, n13, n12, n6, n7, 0, n2, n3, 20);
                    }
                    ++n11;
                    n2 += n6;
                }
                ++n10;
                n3 += n7;
            }
            return;
        }
    }
}

