/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.microemu.app.ui.swing.logconsole.LogTextArea;
import org.microemu.app.util.RuntimeDetect;
import org.microemu.log.Logger;
import org.microemu.log.LoggerAppender;
import org.microemu.log.LoggingEvent;
import org.microemu.log.QueueAppender;
import org.microemu.log.StdOutAppender;

public class SwingLogConsoleDialog
extends JFrame
implements LoggerAppender {
    private boolean a;
    private LogTextArea b;
    private Vector c = new Vector();

    public SwingLogConsoleDialog(Frame container, QueueAppender queueAppender) {
        super("Log console");
        this.setIconImage(((Frame)container).getIconImage());
        container = new JMenuBar();
        Serializable serializable = new JMenu("Log");
        Object object = new JMenuItem("Clear");
        ((AbstractButton)object).addActionListener(new aQ(this));
        ((JMenu)serializable).add((JMenuItem)object);
        ((JMenu)serializable).addSeparator();
        object = new JCheckBoxMenuItem("Show record location");
        ((JCheckBoxMenuItem)object).setState(Logger.isLocationEnabled());
        ((AbstractButton)object).addActionListener(new aR(this, (JCheckBoxMenuItem)object));
        ((JMenu)serializable).add((JMenuItem)object);
        object = new JCheckBoxMenuItem("Write to standard output");
        ((JCheckBoxMenuItem)object).setState(StdOutAppender.enabled);
        ((AbstractButton)object).addActionListener(new aS(this, (JCheckBoxMenuItem)object));
        ((JMenu)serializable).add((JMenuItem)object);
        ((JMenuBar)container).add((JMenu)serializable);
        if (RuntimeDetect.isJava15()) {
            serializable = new JMenu("Threads");
            object = new JMenuItem("ThreadDump to console");
            ((AbstractButton)object).addActionListener(new aT(this));
            ((JMenu)serializable).add((JMenuItem)object);
            object = new JMenuItem("ThreadDump to file");
            ((AbstractButton)object).addActionListener(new aU(this));
            ((JMenu)serializable).add((JMenuItem)object);
            ((JMenuBar)container).add((JMenu)serializable);
        }
        this.setJMenuBar((JMenuBar)container);
        this.b = new LogTextArea(20, 40, 1000);
        serializable = new Font("Monospaced", 0, 12);
        this.b.setFont((Font)serializable);
        object = new JScrollPane(this.b);
        ((JComponent)object).setAutoscrolls(false);
        this.getContentPane().add((Component)object);
        Logger.addAppender(this);
        Logger.removeAppender(queueAppender);
        while ((object = queueAppender.poll()) != null) {
            this.append((LoggingEvent)object);
        }
    }

    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        this.a = true;
        if (this.a) {
            SwingUtilities.invokeLater(new aV(this, 0));
        }
    }

    public void append(LoggingEvent loggingEvent) {
        Serializable serializable;
        Object object;
        long l2 = loggingEvent.getEventTime();
        Serializable serializable2 = new SimpleDateFormat("HH:mm:ss.SSS ");
        serializable2 = new StringBuffer(((DateFormat)serializable2).format(new Date(l2)));
        if (loggingEvent.getLevel() == 4) {
            ((StringBuffer)serializable2).append("Error:");
        }
        ((StringBuffer)serializable2).append(loggingEvent.getMessage());
        if (loggingEvent.hasData()) {
            ((StringBuffer)serializable2).append(" [").append(loggingEvent.getFormatedData()).append("]");
        }
        if (((String)(object = (serializable = loggingEvent.getLocation()) == null ? "" : serializable.getClassName() + "." + serializable.getMethodName() + "(" + serializable.getFileName() + ":" + serializable.getLineNumber() + ")")).length() > 0) {
            ((StringBuffer)serializable2).append("\n\t  ");
        }
        ((StringBuffer)serializable2).append((String)object);
        if (loggingEvent.getThrowable() != null) {
            object = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)object);
            loggingEvent.getThrowable().printStackTrace(printStream);
            printStream.flush();
            ((StringBuffer)serializable2).append(object.toString());
        }
        ((StringBuffer)serializable2).append("\n");
        String string = ((StringBuffer)serializable2).toString();
        serializable = this;
        boolean bl2 = false;
        serializable2 = ((SwingLogConsoleDialog)serializable).c;
        synchronized (serializable2) {
            if (((SwingLogConsoleDialog)serializable).c.isEmpty()) {
                bl2 = true;
            }
            ((SwingLogConsoleDialog)serializable).c.addElement(string);
        }
        if (bl2 && ((SwingLogConsoleDialog)serializable).a) {
            SwingUtilities.invokeLater(new aV((SwingLogConsoleDialog)serializable, 0));
        }
    }

    public static Vector a(SwingLogConsoleDialog swingLogConsoleDialog) {
        return swingLogConsoleDialog.c;
    }

    public static LogTextArea b(SwingLogConsoleDialog swingLogConsoleDialog) {
        return swingLogConsoleDialog.b;
    }
}

