/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;

public class IOUtils {
    public static String getCanonicalFileURL(File object) {
        object = ((File)object).getAbsoluteFile().getPath();
        if (File.separatorChar != '/') {
            object = ((String)object).replace(File.separatorChar, '/');
        }
        if (!((String)object).startsWith("//")) {
            object = ((String)object).startsWith("/") ? "//" + (String)object : "///" + (String)object;
        }
        return "file:" + (String)object;
    }

    public static String getCanonicalFileClassLoaderURL(File file) {
        String string = IOUtils.getCanonicalFileURL(file);
        if (file.isDirectory() && !string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    public static void copyFile(File file, File file2) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            IOUtils.copyToFile(fileInputStream, file2);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
    }

    public static void copyToFile(InputStream inputStream, File object) {
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            fileOutputStream = new FileOutputStream((File)object);
            object = new byte[1024];
            while ((n2 = inputStream.read((byte[])object)) != -1) {
                fileOutputStream.write((byte[])object, 0, n2);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    public static void closeQuietly(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void closeQuietly(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

